package edu.uky.ai.ml.nn;

/**
 * A special subclass of {@link Neuron} whose value can be directly set.
 * 
 * @author Stephen G. Ware
 */
public class InputNeuron extends Neuron {

	@Override
	public double getValue() {
		return value;
	}
	
	/**
	 * Sets the node's value.
	 * 
	 * @param value the value
	 */
	public void setValue(double value) {
		invalidate();
		this.value = value;
		valid = true;
	}
}
